﻿CREATE PROCEDURE [PanelMgmt].[usp_PMUpdateMasterLabIndexFromWorkload] 

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=============================================================================================================
--Requestor				: Jianji Yang
--Author                : Steve Schreiner
--Object/SP Name		: [PanelMgmt].[usp_PMUpdateMasterLabIndexFromWorkload]
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				:    
--Report				: None Yet
--Folder				:
--Report Loc            : 
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-04-2014
--Last Changed          : 08-24-2017  
--Last Changed By		: Brian Diggs
--Reason For Change		: Rebuild as an inner join rather than an assembled string which is exec'd
--
--Last Changed          : 05-15-2015  
--Last Changed By		: Jianji Yang
--Reason For Change		: exclude NON-HDL from 668 which is assigned to LDL workload code                             
--Purpose               : Update Panel Management Master Lab Index table 
--                        with lab test with validate workload codes.
--===============================================================================================================
BEGIN

	insert			[PanelMgmt].[PMMasterLabIndex]
	select 
					li.LabChemTestSID,
					li.Sta3n,
					li.LabChemTestName,
					tg.ResultForTestNumeric,
					getdate() as DateExtracted,
					tg.TestGroup,
					null as LOINC,
					nc.WorkloadCode
	from			[CDWWork].[dim].[LabChemTest] as li
	left outer join [CDWWork].[dim].[NationalVALabCode] as nc on
					li.NationalVALabCodeSID = nc.NationalVALabCodeSID
	inner join		[PanelMgmt].[PMMasterCohortSite] as cs on
					li.Sta3n = cs.Sta3n
	inner join		(select distinct
						TestGroup,
						ResultForTestNumeric,
						TestSearchCriteria
					from [PanelMgmt].[PMMasterCohortLabTestGroups]) as tg on
					nc.WorkloadCode like tg.TestSearchCriteria
	where			not exists (select ni.LabChemTestSID
									from [PanelMgmt].[PMMasterLabIndex] as ni
									where li.LabChemTestSID = ni.LabChemTestSID
										  and li.Sta3n = ni.Sta3n)
	order by		li.Sta3n

	-- remove non HDL lab with LDL workload code assigned. working with local CAC to reassign appropiate code 
	-- LabChemTestSID	LabChemTestIEN	Sta3n	LabChemTestName	    LabChemPrintTestName	NLTNationalVALabCodeSID	NationalVALabCodeSID
	-- 800223162                  7054    668   NON-HDL CHOLESTEROL NHDL                    800522569               800398429

	delete FROM [PanelMgmt].[PMMasterLabIndex] where LabChemTestName like '%NON-HDL%'

END